unit abc1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls, Buttons;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    GroupBox1: TGroupBox;
    StatusBar1: TStatusBar;
    Memo1: TMemo;
    GroupBox2: TGroupBox;
    BitBtn1: TBitBtn;
    Label1: TLabel;
    RadioGroup1: TRadioGroup;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    Memo2: TMemo;
    Button1: TButton;
    StaticText1: TStaticText;
    StaticText2: TStaticText;
    StaticText3: TStaticText;
    StaticText4: TStaticText;
    ComboBox1: TComboBox;
    GroupBox3: TGroupBox;
    GroupBox4: TGroupBox;
    Edit1: TEdit;
    Edit2: TEdit;
    BitBtn5: TBitBtn;
    BitBtn6: TBitBtn;
    StaticText5: TStaticText;
    Button2: TButton;
    BitBtn7: TBitBtn;
    StaticText6: TStaticText;
    BitBtn8: TBitBtn;
    Memo3: TMemo;
    GroupBox5: TGroupBox;
    Edit3: TEdit;
    StaticText7: TStaticText;
    StaticText8: TStaticText;
    Edit4: TEdit;
    BitBtn9: TBitBtn;
    Edit5: TEdit;
    Edit6: TEdit;
    StaticText9: TStaticText;
    StaticText10: TStaticText;
    procedure RadioGroup1Click(Sender: TObject);
    procedure ComboBox1KeyPress(Sender: TObject; var Key: Char);
    procedure FormCreate(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure BitBtn6Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn7Click(Sender: TObject);
    procedure BitBtn8Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure BitBtn9Click(Sender: TObject);

  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;
  MyHeadNumberLabel:array[0..44] of TLabel;                                     //Numerierung der Matrix-Tabelle
  MyMatrixPanel:array[0..2025] of TPanel;                                       //Felder der Matrix-Tabelle
  MyMatrixShape:array[0..2025] of TShape;                                       //zum Schalten der Blind-Felder der Matrix-Tabelle
  MyHeadlineLabel:array[0..44] of TLabel;                                       //Beschriftung der Spalten der Matrix-Tabelle
  MyRowNumberLabel:array[0..44] of TLabel;                                      //Beschriftung der Zeilen der Matrix-Tabelle
  MyRowLabel:array[0..44] of TLabel;                                            //Beschriftung der Matrix-Tabelle
  inputtext, outputtext, substitutionstext:string;
  size,index,dimension,row,column,position,counter:integer;                     //Zeichenanzahl, Zeichenzhler, Zeilenzhler, Spaltenzhler, Zeichenposition,Zhler fr alles
  zeichen:char;

implementation

{$R *.dfm}

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
  if RadioGroup1.ItemIndex=0
  then
  begin
    Label1.Caption:='Encoding ABC-Chiffre';
  end
  else
  begin
    Label1.Caption:='Encoding ABCD-Chiffre';
  end;
end;

procedure TForm1.ComboBox1KeyPress(Sender: TObject; var Key: Char);
begin
  if not (Key in [#8,'0'..'9','a'..'z','A'..'Z']) then Key:=#0;
  if (Key in ['a'..'z']) then Key:=chr(ord(Key)-32);
end;

procedure TForm1.FormCreate(Sender: TObject);

var
  i,j,topwert,row_number,matrixpanel_number,headlinelabel_number,headnumberlabel,rowlabelnumber:integer;

begin
  //Komponenten-Array fr MyMatrixPanel deklarieren
  matrixpanel_number:=0;                                                        //erster MyMatrixPanel-Index
  topwert:=60;
  for i:=0 to 44 do
  begin
    for j:=0 to 44 do
    begin
      MyMatrixPanel[matrixpanel_number]:=TPanel.Create(self);
      with MyMatrixPanel[matrixpanel_number] do
      begin
        Parent:=GroupBox3;
        width:=12;
        Left:=15*j+55;
        Top:=topwert;
        Height:=12;
        Enabled:=true;
        Color:=clYellow;
        Font.Color:=clBlack;
        Font.Size:=8;
        Font.Name:='CourierNew';
        Font.Style:=[FsBold];
        Caption:=char(random(26)+65);                                           //forlaufend mit zuflligen Zeichen fllen
        Tag:=matrixpanel_number;
        Show;
        Enabled:=false;                                                         //alle werden erst einmal falsch geschalten
        inc(matrixpanel_number);
      end;//end with                                                            //Panel-Komponeten-Index erhhen
    end;//end j Schleife
    topwert:=topwert+15;
  end;//end i Schleife - alle MyMatrixPanel-Komponenten sind generiert

  //Komponenten-Array fr MyRowLabel deklarieren
  row_number:=0;                                                                //erster MyRowLabel-Index
  for i:=0 to 44 do
  begin
    MyRowLabel[row_number]:=TLabel.Create(self);
    with MyRowLabel[row_number] do
    begin
      Parent:=GroupBox3;
      width:=15;
      Left:=30;
      Top:=15*i+60;
      Height:=15;
      Font.Color:=clRed;
      Font.Size:=8;
      Font.Name:='Times New Roman';
      Font.Style:=[FsBold];
      Caption:=IntToStr(i+1);                                                   //forlaufend mit zuflligen Zeichen fllen
      Tag:=i;
      Show;
      inc(row_number);
    end;//end with                                                              //Panel-Komponeten-Index erhhen
  end;//end i Schleife - alle MyRowLabel-Komponenten sind generiert

  //Komponenten-Array fr MyHeadNumberLabel deklarieren
  headnumberlabel:=0;                                                           //erster HeadlineNumberPanel-Index
  for i:=0 to 44 do
  begin
    MyHeadNumberLabel[headnumberlabel]:=TLabel.Create(self);
    with MyHeadNumberLabel[headnumberlabel] do
    begin
      Parent:=GroupBox3;
      width:=15;
      Left:=15*i+55;
      Top:=20;
      Height:=15;
      Font.Color:=clBlack;
      Font.Size:=8;
      Font.Name:='Times New Roman';
      Font.Style:=[FsBold];
      Caption:=IntToStr(i+1);                                                   //forlaufend aufsteigenden Zahlen fllen
      Tag:=i;
      Show;
      inc(headnumberlabel);
    end;//end with                                                              //Panel-Komponeten-Index erhhen
  end;//end i Schleife - alle HeadlinePanel-Komponenten sind generiert

  //Komponenten-Array fr MyRowNumberLabel deklarieren
  rowlabelnumber:=0;                                                                //erster MyRowLabel-Index
  for i:=0 to 44 do
  begin
    MyRowNumberLabel[rowlabelnumber]:=TLabel.Create(self);
    with MyRowNumberLabel[rowlabelnumber] do
    begin
      Parent:=GroupBox3;
      width:=15;
      Left:=10;
      Top:=15*i+60;
      Height:=15;
      Font.Color:=clBlack;
      Font.Size:=8;
      Font.Name:='Times New Roman';
      Font.Style:=[FsBold];
      Caption:=IntToStr(i+1);                                                   //forlaufend mit zuflligen Zeichen fllen
      Tag:=i;
      Show;
      inc(rowlabelnumber);
    end;//end with                                                              //Panel-Komponeten-Index erhhen
  end;//end i Schleife - alle MyRowNumberLabel-Komponenten sind generiert

  //Komponenten-Array fr MyHeadlinePanel deklarieren
  headlinelabel_number:=0;                                                      //erster HeadlinePanel-Index
  for i:=0 to 44 do
  begin
    MyHeadlineLabel[headlinelabel_number]:=TLabel.Create(self);
    with MyHeadlineLabel[headlinelabel_number] do
    begin
      Parent:=GroupBox3;
      width:=15;
      Left:=15*i+55;
      Top:=40;
      Height:=15;
      Font.Color:=clRed;
      Font.Size:=8;
      Font.Name:='Times New Roman';
      Font.Style:=[FsBold];
      Caption:=IntToStr(i+1);                                                   //forlaufend aufsteigenden Zahlen fllen
      Tag:=i;
      Show;
      inc(headlinelabel_number);
    end;//end with                                                              //Panel-Komponeten-Index erhhen
  end;//end i Schleife - alle HeadlinePanel-Komponenten sind generiert
end;

procedure TForm1.BitBtn2Click(Sender: TObject);                                 //Eingabetext bereinigen

var
  i,counter,row:integer;
  behind,changed:boolean;
  
begin
  StatusBar1.Panels[1].Text:='Eingabetext bereinigt';
  BitBtn2.Enabled:=false;                                                       //Text kann nicht mehr bereinigt werden
  BitBtn3.Enabled:=false;                                                       //Eingabetext kann nicht mehr gelscht werden
  BitBtn4.Enabled:=true;                                                        //Fnfer-Gruppen knnen geschalten werden
  BitBtn5.Enabled:=true;                                                        //Restmatrix kann abgeschnitten werden
  size:=Length(Memo1.Text);
  Edit1.Text:=IntToStr(size);                                                   //Lnge des unbereinigten Textes vermerken
  if size>0
  then
  begin
    inputtext:=Memo1.Text;
    i:=1;
    while behind=false do
    begin                 //begin of while
      changed:=false;
      inputtext[i]:=UpCase(inputtext[i]);
      if (not(inputtext[i] in['0'..'9','','','','','','','a'..'z','A'..'Z','']))
      then
      begin             //begin of if3
        delete(inputtext,i,1);
        changed:=true;
      end;              //end of if3
      if length(inputtext)>0
      then
      begin                  //begin of if sekundaer0
        case inputtext[i] of
        '0': begin           //begin of 0
          delete(inputtext,i,1);
          insert('NULL',inputtext,i);
          i:=i+3;
        end;            //end of 0
        '1': begin           //begin of 1
          delete(inputtext,i,1);
          insert('EINS',inputtext,i);
          i:=i+3;
        end;            //end of 1
        '2': begin           //begin of 2
          delete(inputtext,i,1);
          insert('ZWO',inputtext,i);
          i:=i+3;
        end;            //end of 2
        '3': begin           //begin of 3
          delete(inputtext,i,1);
          insert('DREI',inputtext,i);
          i:=i+3;
        end;            //end of 3
        '4': begin           //begin of 4
          delete(inputtext,i,1);
          insert('VIER',inputtext,i);
          i:=i+3;
        end;            //end of 4
        '5': begin           //begin of 5
          delete(inputtext,i,1);
          insert('FUENF',inputtext,i);
          i:=i+4;
        end;            //end of 5
        '6': begin           //begin of 6
          delete(inputtext,i,1);
          insert('SECHS',inputtext,i);
          i:=i+4;
        end;            //end of 6
        '7': begin           //begin of 7
        delete(inputtext,i,1);
        insert('SIEBEN',inputtext,i);
        i:=i+5;
        end;            //end of 7
        '8': begin           //begin of 8
        delete(inputtext,i,1);
        insert('ACHT',inputtext,i);
        i:=i+3;
        end;            //end of 8
        '9': begin           //begin of 9
          delete(inputtext,i,1);
          insert('NEUN',inputtext,i);
          i:=i+3;
        end;            //end of 9
        '', '': begin      //begin of oe
          delete(inputtext,i,1);
          insert('OE',inputtext,i);
          i:=i+1;
        end;            //end of oe
        '', '': begin      //begin of ae
          delete(inputtext,i,1);
          insert('AE',inputtext,i);
          i:=i+1;
        end;            //end of ae
        '', '': begin      //begin of ue
          delete(inputtext,i,1);
          insert('UE',inputtext,i);
          i:=i+1;
        end;            //end of ue
        '': begin      //begin of sz
          delete(inputtext,i,1);
          insert('SZ',inputtext,i);
          i:=i+1;
        end;            //end of sz
      end;              //end of if sekundaer0
      if changed=false
      then
      begin
        inc(i);
      end;{end of then}
      if i>length(inputtext)
      then
      begin
        behind:=true;
      end;{end of then}
    end;                  //end of while
    end;
    Memo1.Clear;
    Memo1.Text:=inputtext;{Text neu einschreiben}
    size:=length(inputtext);
    StatusBar1.Panels[3].Text:=IntToStr(size);
    dimension:=dimension+size;
    Edit2.Text:=IntToStr(dimension);
  end{end of then}
  else
  begin
    with Application do
    begin
      NormalizeTopMosts;
      MessageBox('Die Eingabeseite darf nicht leer sein!', 'Achtung', MB_OK);
      RestoreTopMosts;
    end;
  end;{end of else}
  //Beginn Eingabezeichen in die Matrix einschreiben
  index:=0;  //Zeiger des aktuellen Zeichens auf die PanelMatrix
  row:=0;   //Zeilenzhler
  counter:=1;  //Zeichenzhler im Eingabetext
  repeat
    zeichen:=inputtext[counter];
    if MyMatrixPanel[index].Enabled=true
    then
    begin
      MyMatrixPanel[index].Caption:=zeichen;
    end
    else
    begin
      while MyMatrixPanel[index].Enabled=false do
      begin
        inc(index);
      end;
      MyMatrixPanel[index].Caption:=zeichen;
    end;
    inc(index);
    inc(counter);
  until counter=length(inputtext)+1;
  for i:=index to 2024 do
  begin
    MyMatrixPanel[i].Caption:='?';
  end;
  //End Eingabezeichen in die Matrix einschreiben}
end;

procedure TForm1.BitBtn4Click(Sender: TObject);

var
  blocktext:string;
  i:integer;

begin
  if BitBtn4.Caption = 'Fnfer-Gruppen schalten'
  then
  begin
    BitBtn4.Caption:='Blocktext schalten';
    blocktext:=inputtext;
    i:=0;
    repeat
      inc(i);
      if i mod 6=0
      then
      begin
        insert(' ',blocktext,i);
        inc(size);
      end;
    until i=size;
    Memo1.Clear;
    Memo1.Text:=blocktext;
  end
  else
  begin
    BitBtn4.Caption:='Fnfer-Gruppen schalten';
    Memo1.Clear;
    Memo1.Text:=inputtext;
  end;
end;

procedure TForm1.BitBtn5Click(Sender: TObject);

var
  i:integer;

begin
  Button1.Enabled:=true;
  BitBtn5.Enabled:=false;                                                       //... die Restmatrix kann nicht mehr abgeschnitten werden werden
  //index:=dimension;
  Edit2.Text:=IntToStr(dimension);                                              //aktuelle Dimension in Index vermerken
  for i:=index to 2024 do
  begin
    MyMatrixPanel[i].Visible:=false;
  end;
  for i:=1 to 44 do
  begin
    if MyMatrixPanel[i*45].Caption='?'
    then
    begin                                                                       //Anzeige der ersten Zeile mit Fragezeichen - das entspricht der Zeilenzahl der mit Text gefllten Matrix
      MyRowNumberLabel[i].Visible:=false;
      MyRowLabel[i].Visible:=false;
    end
    else
    begin
      Edit6.Text:=IntToStr(i+1);                                                //letzte mit Zeichen gefllte Zeilennummer eintragen
    end;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);                                 //Substitution des bereinigten Eingabetextes

var
  i,j:integer;

begin
  Button1.Enabled:=false;                                                       //Substitution kann nicht mehr geschalten werden
  Button2.Enabled:=true;                                                        //Transposition kann jetzt geschalten werden
  BitBtn8.Enabled:=true;                                                        //Fnfer-Gruppen fr den Sbstitutionstext knnen geschrieben werden
  substitutionstext:='';                                                        //Substitutionstext leer schreiben
  dimension:=1;                                                                 //Zeichenzhler inputtext-Lnge auf Anfang setzen
  counter:=0;
  if RadioGroup1.ItemIndex=0
  then
  begin //ABC-Chiffre ist gewhlt
    repeat
      zeichen:=inputtext[dimension];
      index:=ord(zeichen);                                                      //index wird hier als ASCII-Zeichencode verwendet
      if counter<=2                                                             //maximale Verschiebung um 2 ist zugelassen
      then
      begin
        index:=index+counter;                                                   //Berechnung des Verstzwertes auf aktuellen ASCII-Code
        if index>90
        then
        begin
          index:=65+index-90;
        end;
      substitutionstext:=substitutionstext+chr(index);
      inc(counter);
      inc(dimension);
      end
      else
      begin
        counter:=0;
      end;
    until dimension=length(inputtext)+1;
  end
  else
  begin //ABCD-Chiffre ist gewhlt
    repeat
      zeichen:=inputtext[dimension];
      index:=ord(zeichen);                                                      //index wird hier als ASCII-Zeichencode verwendet
      if counter<=3                                                             //maximale Verschiebung um 3 ist zugelassen
      then
      begin
        index:=index+counter;                                                   //Berechnung des Verstzwertes auf aktuellen ASCII-Code
        if index>90
        then
        begin
          index:=65+index-90;
        end;
        substitutionstext:=substitutionstext+chr(index);
        inc(counter);
        inc(dimension);
      end
      else
      begin
        counter:=0;
      end;
    until dimension=length(inputtext)+1;
  end;
  Edit2.Text:=IntToStr(Length(substitutionstext));
  Memo2.Text:=substitutionstext;                                                //kompletten Substitutionstext in Ausgabe-Memo schreiben
  //Eintragen der Substitutions-Ciffren in die Transpositionsmatrix
  {- size reprsentiert die Lnge des Substitutions-Textes
   - Anschlag fr die zeichen-Eintragung ist die Lnge des bereits erstellten "substitutionstextes"
   - ich bentige eine Gre, um im Feld der Gesamtmatrix weiter zu zhlen (egal, ob Text oder "?")
   - ich bentige einen Zhler fr die Zeichen der Variable "substitutionstext"}


  index:=0;  //Zeiger des aktuellen Zeichens auf die PanelMatrix
  counter:=1;  //Zeichenzhler im Eingabetext
  repeat
    zeichen:=substitutionstext[counter];
    if MyMatrixPanel[index].Enabled=true
    then
    begin
      MyMatrixPanel[index].Caption:=zeichen;
    end
    else
    begin
      while MyMatrixPanel[index].Enabled=false do
      begin
        inc(index);
      end;
      MyMatrixPanel[index].Caption:=zeichen;
    end;
    inc(index);
    inc(counter);
  until counter=size;

  {substcounter:=1;                                                              //Zhler fr die Lnge des Substitutions-Textes auf 1
  matrixcounter:=0;                                                             //Zhler fr die Matrixfelder
  repeat
    if MyMatrixPanel[matrixcounter].Caption<>'?'
    then
    begin
      MyMatrixPanel[matrixcounter].Caption:=substitutionstext[substcounter];    //per 31.1.2018 festgestellt: der Fehler ist in der Formel - finde ihn
      inc(substcounter);
      inc(matrixcounter);
    end
    else
    begin
      inc(matrixcounter);
    end;
  until substcounter=size;}
  {j:=0;
  for i:=0 to length(substitutionstext)-1 do
  begin
    if MyMatrixPanel[i].Caption<>'?'
    then
    begin
      MyMatrixPanel[j*45+i].Caption:=substitutionstext[i+1];                    //per 31.1.2018 festgestellt: der Fehler ist in der Formel - finde ihn
    end
    else
    begin
      inc(j);
    end;
  end;}
end;

procedure TForm1.BitBtn6Click(Sender: TObject);                                 //Transpositions-Key setzen

var
  i,j:integer;
  
begin
  BitBtn6.Enabled:=false;                                                       //Transpositionskey kann nicht gesetzt werden
  BitBtn7.Enabled:=true;                                                        //Wiederholen nicht mglich
  BitBtn2.Enabled:=true;                                                        //Eingabetext kann jetzt bereinigt werden
  Edit5.Text:=IntToStr(length(ComboBox1.Text));                                 //Spaltenanzahl registrieren
  for i:=0 to 2024 do
  begin
    MyMatrixPanel[i].Enabled:=true;
  end;
  //Anfang Abschneiden des Restfeldes von der Spalten-Keywordlnge
  for i:=0 to length(ComboBox1.Text)-1 do
  begin
    MyHeadlineLabel[i].Caption:=ComboBox1.Text[i+1];
  end;
  for j:=i to 44 do
  begin
    MyHeadlineLabel[j].Visible:=false;
    MyHeadNumberLabel[j].Visible:=false;
  end;
  for i:=length(ComboBox1.Text) to 44 do
  begin
    for j:=0 to 44 do
    begin
      MyMatrixPanel[j*45+i].Caption:='.';
      MyMatrixPanel[j*45+i].Visible:=false;
      MyMatrixPanel[j*45+i].Enabled:=false;
    end;
  end;
  //Ende Abschneiden des Restfeldes von der Spalten-Keywordlnge
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
  inputtext:='';
  Memo1.Clear;
  Memo2.Clear;
end;

procedure TForm1.BitBtn7Click(Sender: TObject);
begin
  Edit5.Text:='???';                                                            //Spaltenanzahl Transposition unbestimmt
  Memo1.Clear;
  Memo2.Clear;
  BitBtn6.Enabled:=true;                                                        //neuen Transpositionscode setzen ist mglich
  BitBtn7.Enabled:=false;                                                       //Wiederholen nicht mglich
  BitBtn8.Enabled:=false;                                                       //Fnfer-Gruppen fr den Sbstitutionstext knnen nicht geschrieben werden
end;

procedure TForm1.BitBtn8Click(Sender: TObject);

var
  blocktext:string;
  i:integer;
  
begin
  if BitBtn8.Caption = 'Fnfer-Gruppen Substitution'
  then
  begin
    BitBtn8.Caption:='Blocktext Substitution';
    blocktext:=substitutionstext;
    i:=0;
    repeat
      inc(i);
      if i mod 6=0
      then
      begin
        insert(' ',blocktext,i);
        inc(size);
      end;
    until i=size;
    Memo2.Clear;
    Memo2.Text:=blocktext;
  end
  else
  begin
    BitBtn8.Caption:='Fnfer-Gruppen Substitution';
    Memo2.Clear;
    Memo2.Text:=substitutionstext;
  end;
end;

//selbstgeschriebene Prozedur zum Tauschen zweier aktueller Spalten
procedure tausch1(l_position,l_i:byte);                                          //bergabe-Parameter sind die aktuelle Position sowie die aktuelle

var
  i:integer;
  help:array[0..44] of char;                                                    //Austausch-Hilfsfeld

begin
  for i:=0 to 44 do
  begin
    help[i]:=MyMatrixPanel[i*45+l_position].Caption[1];
    Form1.Memo3.Text:=Form1.Memo3.Text+help[i];
  end;
  for i:=0 to 44 do
  begin
    MyMatrixPanel[i*45+l_position].Caption:=MyMatrixPanel[i*45+l_i].Caption;
  end;
  for i:=0 to 44 do
  begin
    MyMatrixPanel[i*45+l_i].Caption:=help[i];
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);

var
  i,j:integer;
  position,ascii:byte;

  {MyHeadNumberLabel:array[0..44] of TLabel;                                     //Numerierung der Matrix-Tabelle
  MyMatrixPanel:array[0..2025] of TPanel;                                       //Felder der Matrix-Tabelle
  MyMatrixShape:array[0..2025] of TShape;                                       //zum Schalten der Blind-Felder der Matrix-Tabelle
  MyHeadlineLabel:array[0..44] of TLabel;                                       //Beschriftung der Spalten der Matrix-Tabelle
  MyRowNumberLabel:array[0..44] of TLabel;                                      //Beschriftung der Zeilen der Matrix-Tabelle
  MyRowLabel:array[0..44] of TLabel;                                            //Beschriftung der Matrix-Tabelle
  inputtext, outputtext, substitutionstext:string;
  size,index,dimension,row,column,position,counter:integer;                     //Zeichenanzahl, Zeichenzhler, Zeilenzhler, Spaltenzhler, Zeichenposition,Zhler fr alles
  zeichen:char;}

  {mein Algorithmus:
  - durchlaufen aller Buchstabn von A bis Z via ASCII-Code
  - mit jedem Zeichen (A - Z) die Spaltenbezeichner von links beginnend durchlaufen
  - wenn bereinstimmung mit aktuellem Zeichen gefunden
  - spaltenweises auslesen, solange Buchstaben in der Cption-Eigenschaft der Komponenten MyMatrixPanel stehen - sonst "?"
  }

begin
 
end;

procedure TForm1.BitBtn9Click(Sender: TObject);

var
  blocktext:string;
  i:integer;

begin
  if BitBtn9.Caption = 'Fnfer-Gruppen Ciphertext'
  then
  begin
    BitBtn9.Caption:='Blocktext schalten';
    blocktext:=outputtext;
    i:=0;
    repeat
      inc(i);
      if i mod 6=0
      then
      begin
        insert(' ',blocktext,i);
        inc(size);
      end;
    until i=size;
    Memo3.Clear;
    Memo3.Text:=blocktext;
  end
  else
  begin
    Memo3.Clear;
    Memo3.Text:=outputtext;
    BitBtn9.Caption:='Fnfer-Gruppen Ciphertext';
  end;
end;

end.procedure TForm1.BitBtn8Click(Sender: TObject);
begin

end;


